package mousedemo;

// File:   mousedemo/MousePanel.java
// Description: Panou care contine doua MousePanels.
// Author: Fred Swartz
// Date:   2005-02-03, 2000-11-29...2002-11-21

 

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

////////////////////////////////////////////////// class DualMousePanel
class DualMousePanel extends JPanel {
    //====================================================== constructor
    public DualMousePanel() {
        //--- Creaza doua MousePanels
        MousePanel mp1 = new MousePanel();
        MousePanel mp2 = new MousePanel();
        
        //--- Adauga margini (nota: marginile sunt inauntrul panoului)
        Border etched = BorderFactory.createEtchedBorder();
        mp1.setBorder(BorderFactory.createTitledBorder(etched, "Panel 1"));
        mp2.setBorder(BorderFactory.createTitledBorder(etched, "Panel 2"));
        
        //--- Aranjeaza panourile
        this.setLayout(new GridLayout(1, 2));
        this.add(mp1);
        this.add(mp2);
    }//end constructor
}
