/** DragBallPanel.java - Panel care permite tirirea mingii.
    @author Fred Swartz
    @version 2004-04-15
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/////////////////////////////////////////////////////////// class DragBallPanel
/** La invocarea ascultatorului mousePressed lse testeaza pozitia
    pentru a vedea daca este in zona mingii.  Daca este, atunci 
    (1) seteaza _canDrag true insemnind fii atent la evenimentele MouseDragged.  
    (2) inregistreaza unde in minge (relativ la coordonatele stinga sus) 
        s-a dat clic, deoarece arata cel mai bine daca tragem de acolo.
*/
public class DragBallPanel extends JPanel implements MouseListener, MouseMotionListener {

    private static final int BALL_DIAMETER = 40; // Diametrul mingii
    //--- variabile instanta
    /** Coord. mingii.  Modificate de ascultatorii mouse.  
        Folosite de paintComponent. */
    private int _ballX     = 50;   // coord x  setata din drag
    private int _ballY     = 50;   // coord y  setata din drag
    
    /** Pozitia in minge a apasarii mouse pentru a face tirirea 
        sa arate mai bine. */
    private int _dragFromX = 0;    // apasat atit de departe in cutia
    private int _dragFromY = 0;    // care margineste mingea.
    
    /** true inseamna ca s-a apasat mouse in minge si este inca in panou.*/
    private boolean _canDrag  = false;
    
    //============================================================= constructor
    /** Constructorul seteza marimea, culorile si adauga ascultatori de mouse.*/
    public DragBallPanel() {
        setPreferredSize(new Dimension(300, 300));
        setBackground(Color.blue);
        setForeground(Color.yellow);
        //--- Adauaga ascultatori de mouse.
        this.addMouseListener(this); 
        this.addMouseMotionListener(this);
    }//endconstructor
    
    //=================================================== method paintComponent
    /** Mingea este desenata la ultimele coordonate inregistrate de ascultatorul  
	  mouse. */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);   // Necesar pentru fundal.
        g.fillOval(_ballX, _ballY, BALL_DIAMETER, BALL_DIAMETER);
    }//end paintComponent
    
    //===================================================== method mousePressed
    /** Seteaza _canDrag daca clicul este in minge (sau in cutia care o 
        margineste, ceea ce arata lene, dar e destul de aproape pentru acest
        program).
        Retine deplasamentul (dragFromX and Y) in minge
        Pentru a-l folosi ca punct relativ de afisat in timpul tiririi.
    */
    public void mousePressed(MouseEvent e) {
        int x = e.getX();   // Salveaza coordonata x  a clicului
        int y = e.getY();   // Salveaza coordonata y  a clicului
        
        if (x >= _ballX && x <= (_ballX + BALL_DIAMETER)
                && y >= _ballY && y <= (_ballY + BALL_DIAMETER)) {
            _canDrag = true;
            _dragFromX = x - _ballX;  // cit de departe de stinga
            _dragFromY = y - _ballY;  // cit de departe de partea de sus
        } else {
            _canDrag = false;
        }
    }//end mousePressed
    
    //============================================================ mouseDragged
    /** Seteaza x,y  la pozitia mouse si redeseneaza. */
    public void mouseDragged(MouseEvent e) {
        if (_canDrag) {   // True doar daca s-a apasat un buton in minge.
            //--- Pozitia mingii de la mouse si deplasamentul clicului original           
	      _ballX = e.getX() - _dragFromX;
            _ballY = e.getY() - _dragFromY;
            
            //--- Nu muta mingea in afara ecranului marginilor stinga-dreapta
            _ballX = Math.max(_ballX, 0);
            _ballX = Math.min(_ballX, getWidth() - BALL_DIAMETER);
            
            //--- Nu muta mingea in afara ecranului marginilor sus-jos
            _ballY = Math.max(_ballY, 0);
            _ballY = Math.min(_ballY, getHeight() - BALL_DIAMETER);
            
            this.repaint(); // Redeseneaza pentru ca s-a schimbat pozitia.
        }
    }//end mouseDragged

    //====================================================== method mouseExited
    /** Opreste tirirea daca mouse iese din panou. */
    public void mouseExited(MouseEvent e) {
        _canDrag = false;
    }//end mouseExited

    //============================================= Ignora alte evenimente mouse.
    public void mouseMoved   (MouseEvent e) {}  // ignora aceste evenimente
    public void mouseEntered (MouseEvent e) {}  // ignora aceste evenimente
    public void mouseClicked (MouseEvent e) {}  // ignora aceste evenimente
    public void mouseReleased(MouseEvent e) {}  // ignora aceste evenimente
}//endclass DragBallPanel

