
/**
 * Simuleaza un rezervor auto pentru carburant
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class RezervorCarburant
{
    private float capacitate; // capacitatea in litri
    private float nivel; // nivelul combustibilului de la 0 la 1
    /**
     * capacitatea minima pentru rezervor: 4 litri
     */
    public static final float CAPACITATE_MIN = 4f;
    /**
     * capacitatea maxima pentru rezervor: 200 litri
     */
    public static final float CAPACITATE_MAX = 200f;
    /**
     * Nivelul minim de combustibil: 0
     */
    public static final float NIVEL_MIN = 0f;
    /**
     * Nivelul maxim de combustibil: 1
     */
    public static final float NIVEL_MAX = 1f;
    /**
     * Creeaza un rezervor de 60 litri, plin 
     */
    public RezervorCarburant()
    {
        this(60f, 1f);
    }

    /**
     * Creeaza un rezervor de carburant
     * @param cap capacitatea in litri - strict pozitiv, >= 4
     * @param niv nivel de umplere intre 0 si 1
     */
    public RezervorCarburant(float cap, float niv)
    {
        if (cap < CAPACITATE_MIN || cap > CAPACITATE_MAX)
        {
            System.out.println("Capacitate incorecta " + cap + 
            " pentru rezervorul de carburant. Se ajusteaza la 60");
            cap = 60f;
        }
        if (niv < NIVEL_MIN || niv > NIVEL_MAX)
        {
            System.out.println("Nivel incorect in rezervor: " + niv + 
            ". Se ajusteaza la 0, adica gol");
            niv = 0f;
        }
        capacitate = cap;
        nivel = niv;
    }
    /**
     * Incearca sa umple rezervorul de combustibil cu cantitatea de carburant data
     * @param cantitate cantitatea de carburant in litri
     * @return cit nu a incaput in rezervor
     */
    public float umple(float cantitate)
    {
        // DE FACUT
        return 0;
    }
    /**
     * Scoate pentru consum din rezervor cantatitea ceruta
     * @param cantitate cantitatea de scos
     * @return true daca extragerea carburantului a reusit pentru toata cantitatea<br />
     * altfel fals
     */
    public boolean scoate(float cantitate)
    {
        // DE FACUT
        return false;
    }
    /**
     * @return capacitatea acestui rezervor, in litri
     */
    public float getCapacitate()
    {
        return capacitate;
    }
    /**
     * @return nivelul carburantului [0..1]
     */
    public float getNivel()
    {
        return nivel;
    }
}
