import java.awt.Color;
/**
*  Reprezinta un automobil.
*  Atributele sunt marca, viteza, puterea motorului 
*  pasul de accelerare, viteza maxima si culoarea.
*  Metodele sunt accelereaza, decelereaza, 
*  getViteza, getVitezaMax, getCuloare, getAcceleratie
*  getPutere, getMarca and getVitezaMax.
*
* @author Laboratory Team
*/
public class Automobil 
{
  private String marca; 
  private int viteza = 0;  // viteza curenta a masinii
  private Color culoare;
  private int putere;
  private int pasAccelerare=0; // cresterea ded viteza la apasarea pe acceleratie
  private int vitezaMax;           // viteza maxima pentru aceasta masina
  private static final int VITEZA_MIN = 0; // viteza minima pentru toate masinile; km/h
  private static final int VITEZA_MAX = 300; // viteza limita pentru toate masinile; km/h
  private static final int PUTERE_MIN = 4; // puterea minima pentru toate masinile; nu mai putin de 4 CP
  private static final int PUTERE_MAX = 500; // puterea maxima pentru toate masinile; nu mai mult de 500 CP
  private static final int PAS_MIN_ACCELERARE = 1; // minimum viteza increase per second when gas pedal pushed
  private static final int PAS_MAX_ACCELERARE = 30; // maximum viteza increase per second when gas pedal pushed
  /**
   * Constructor pentru a crea un nou obiect Automobil
   * @param marca nume sau producator.
   * @param culoare culoarea obiectului Automobil - una dintre constantele Color din Java
   * @param putere puterea motorului
   * @param pasAccelerare cresterea de viteza la apasarea acceleratiei
   */
  public Automobil(String marca, Color culoare, int putere, int vitezaMax, int pasAccelerare) 
  {
     //creaza un nou obiect Automobil cu numele de marca specificat, cu culoarea, puterea motorului,
     //viteza maxima si pasul de accelerare specificat
     this.marca = marca;
     this.culoare = culoare;
     this.putere = (putere > 4)? putere: 4;
     if (vitezaMax < 0) this.vitezaMax = VITEZA_MIN; // this car wil never move
     else 
     if (vitezaMax < VITEZA_MAX) this.vitezaMax = vitezaMax;
     else vitezaMax = VITEZA_MAX;
     if (putere < PUTERE_MIN) this.putere = PUTERE_MIN;
     else 
     if (putere > PUTERE_MAX) this.putere=PUTERE_MAX;
     if (pasAccelerare < PAS_MIN_ACCELERARE)
        this.pasAccelerare = PAS_MIN_ACCELERARE;
     else
     if (pasAccelerare > PAS_MAX_ACCELERARE)
        this.pasAccelerare = PAS_MIN_ACCELERARE;
     else
        this.pasAccelerare = pasAccelerare;
  }

  /**
   * Simuleaza apasarea accelaratiei.
   * @return noua viteza
   */
  public int accelereaza() 
  {
     int vitezaNoua = viteza + getAcceleratie();
     if(vitezaNoua <= getVitezaMax()) 
     {
        viteza = vitezaNoua;
     }
     else 
     {
        viteza = getVitezaMax();
     }
     return viteza;
  }

  /**
   * Simuleaza eliberarea acceleratiei.
   * @return noua viteza
   */
  public int decelereaza() 
  {
     if(viteza > VITEZA_MIN) 
     {
        viteza--;
     }
     return viteza;
  }

  /**
   * @return viteza curenta
   */
  public int getViteza() 
  {
     return viteza;
  }

  /**
   * @return viteza maxima
   */
  public int getVitezaMax() 
  {
     return VITEZA_MAX;
  }

  /**
   * @return culoarea masinii
   */
  public Color getCuloare() 
  {
     return culoare;
  }

   /**
   * @return numele marcii masinii
   */
  public String getMarca() 
  {
     return marca;
  }

  /**
   * @return pasul cu care accelereaza masina
   */
  public int getAcceleratie() 
  {
     return pasAccelerare;
  }

  /**
   * @return puterea masinii
   */
  public int getPutere() 
  {
     return putere;
  }
}
