import java.util.Random;
import junit.framework.TestCase;

/**
   A JUnit test for the RootApproximator class.
*/
public class RootApproximatorTest extends TestCase
{
   
   public void testSimpleCase() 
   {
      double x = 4;
      RootApproximator a = new RootApproximator(x);
      double r = a.getRoot();
      assertTrue(Numeric.approxEqual(r, 2));
   }

   public void testBoundaryCase() 
   {
      double x = 0;
      RootApproximator a = new RootApproximator(x);
      double r = a.getRoot();
      assertTrue(Numeric.approxEqual(r, 0));
   }

   public void testRandomValues()
   {
      final double SAMPLES = 100;
      Random generator = new Random();
      for (int i = 1; i <= SAMPLES; i++)
      {  
         // Generate random test value

         double x = 1000 * generator.nextDouble();
         RootApproximator r = new RootApproximator(x);
         double y = r.getRoot();
         assertTrue(Numeric.approxEqual(y * y, x));
      }
   }

   public void testOracle()
   {
      final double SAMPLES = 100;
      Random generator = new Random();
      for (int i = 1; i <= SAMPLES; i++)
      {  
         // Generate random test value

         double x = 1000 * generator.nextDouble();
         RootApproximator r = new RootApproximator(x);
         double y = r.getRoot();
         double oracleValue = Math.pow(x, 0.5); 
         assertTrue(Numeric.approxEqual(y, oracleValue));
      }
   }
}

