// Demonstrates FileChannel and ByteBuffer.
import java.io.*;
import java.nio.*;
import java.nio.channels.*;

public class FileChannelTest 
{
   private FileChannel fileChannel;

   // no-arg constructor
   public FileChannelTest()
   {
      // create random access file and get file channel
      try 
      {
         RandomAccessFile file = new RandomAccessFile( "Test", "rw" );
         fileChannel = file.getChannel();
      }
      catch ( IOException ioException ) 
      {
         ioException.printStackTrace();
      }

   } // end constructor FileChannelTest

   // write to writeChannel
   public void writeToFile() throws IOException
   {
      // create buffer for writing
      ByteBuffer buffer = ByteBuffer.allocate( 14 );

      // write an int, a char and a double to buffer
      buffer.putInt( 100 );
      buffer.putChar( 'A' );
      buffer.putDouble( 12.34 );

      // flip buffer and write buffer to fileChannel
      buffer.flip();
      fileChannel.write( buffer );
   } 

   // read from readChannel
   public void readFromFile() throws IOException
   {
      String content = "";

      // create buffer for read
      ByteBuffer buffer = ByteBuffer.allocate( 14 );
      
      // read buffer from fileChannel
      fileChannel.position( 0 );
      fileChannel.read( buffer );

      // flip buffer for reading
      buffer.flip();

      // obtain content
      content += buffer.getInt() + ", " + buffer.getChar() + ", " + 
         buffer.getDouble();

      System.out.println( "File contains: " + content );

      // close fileChannel
      fileChannel.close();

   } 
   public static void main( String[] args ) 
   {
      FileChannelTest application = new FileChannelTest();
      
      // write to file and then read from file
      try 
      {
         application.writeToFile();
         application.readFromFile();
      } 
      catch ( IOException ioException ) 
      {
         ioException.printStackTrace();
      }
   } 
}
